#include <RcppArmadillo.h>
using namespace Rcpp;
// [[Rcpp::depends(RcppArmadillo)]]


// [[Rcpp::export]]
arma::mat fillJcpp(NumericVector S, NumericVector T) {
    int n = S.size()-1;
    arma::mat J(n, n, arma::fill::zeros);
    for (int ii=0; ii<n; ii++) {
        for (int jj=ii; jj<n; jj++) {
            J(ii, jj) = T(jj+1)-T(ii) - pow(S(jj+1)-S(ii), 2)/(jj-ii+1);
        }   
    }
    return J;
}

/*** R
y <- rnorm(5)
S <- c(0, cumsum(y))
T <- c(0, cumsum(y^2))
fillJcpp(S, T)
getJ(y)
fillJcpp(S, T)-getJ(y)
*/
